implementation module pointer;

/*
load_long :: !Int -> Int;
load_long n = code {
		instruction 139
		instruction 0	| movl (%eax),%eax
	} 

store_long :: !Int !Int -> Int;
store_long p n = code {
		instruction 137
		instruction 3	| movl %eax,(%ebx)
		pop_b 1
	}

store_byte :: !Int !Int -> Int;
store_byte p n = code {
		instruction 136
		instruction 3	| movb %al,(%ebx)
		pop_b 1
	}
*/

load_long :: !Int -> Int;
load_long n = code {
		instruction 0x83180000	| lwz r24,0(r24)
	} 

store_long :: !Int !Int -> Int;
store_long p n = code {
		instruction 0x93190000	| stw r24,0(r25)
		pop_b 1
	}

store_byte :: !Int !Int -> Int;
store_byte p n = code {
		instruction 0x9b190000	| stb r24,0(25)
		pop_b 1
	}

errno_address :: Int;
errno_address = code {
        pushD errno
}
/*
errno_address = code {
        ccall __errno_location ":I"
}
*/
